/**
* \file: FrameInternal.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "Common.h"
#include "FrameInternal.h"

namespace adit { namespace carplay
{

FrameInternal::FrameInternal()
{
    onComplete = nullptr;
    context = nullptr;
    frameBufsize = INIT_BUFF;
    this->dataPtr = malloc(frameBufsize);
    if(this->dataPtr == nullptr)
    {
        LOG_ERROR((dipo, "Initial memory allocate for video frame failed!"));
    }
}

FrameInternal::~FrameInternal()
{
    if(this->dataPtr != nullptr)
    {
        free((void*)this->dataPtr);
    }
    Release();
}

void FrameInternal::SetContext(ScreenStreamCompletion_f onComplete, void* context)
{
    this->onComplete = onComplete;
    this->context = context;
}


void FrameInternal::SetDisplayTime(uint64_t displayTime)
{
    this->displayTime = displayTime;
    this->length = 0;
}

bool FrameInternal::CreateNewBuff(const size_t reqBufsize)
{
    void* tempBuf = realloc((void*)this->dataPtr,reqBufsize);
    if(tempBuf != nullptr)
    {
        this->dataPtr = tempBuf;
        frameBufsize = reqBufsize;
        return true;

    }
    else
    {
        return false;
    }
}

void FrameInternal::Release()
{
    if (onComplete != nullptr)
    {
        onComplete(context);
        onComplete = nullptr;
    }
}

void FrameInternal::Append(const void* data,size_t length)
{
    memcpy(((char*)this->dataPtr) + this->length, data, length);
    this->length += length;
}

} } /* namespace adit { namespace carplay */
